//------------------------------------------------------------------------------
// File: cmn_math.cs
// This file contains common math related functions
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Helper function to form a vector given its three coordinates
//! \param %x X coordinate
//! \param %y Y coordinate
//! \param %z Z coordinate
//! \retval vector Vector formed
////////////////////////////////////////////////////////////////////////////////
function slgFormVector(%x, %y, %z)
{
   return %x @ " " @ %y @ " " @ %z;
}

////////////////////////////////////////////////////////////////////////////////
//! Rounds a float value to the nearest whole number
//! \param %x Float value
//! \retval int Nearest whole number
////////////////////////////////////////////////////////////////////////////////
function slgRound(%x)
{
   %xFloor = mFloor(%x);
   %xCeil  = mCeil(%x);
   %dFloor = mAbs(%xFloor - %x);
   %dCeil  = mAbs(%xCeil - %x);
   if(%dFloor < %dCeil) {
      return %xFloor;
   }
   else {
      return %xCeil;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Clamps a value to low and high
//! \param %val Value to clamp
//! \param %low Low amount
//! \param %high High amount
//! \retval Clamped value
////////////////////////////////////////////////////////////////////////////////
function slgClamp(%val, %low, %high)
{
   if(%val < %low) {
      %val = %low;
   }
   else if(%val > %high) {
      %val = %high;
   }
   return %val;
}

// End cmn_math.cs